/*
 *  SPDX-FileCopyrightText: 2004-2006 Cyrille Berger <cberger@cberger.net>
 *
 *  SPDX-License-Identifier: GPL-2.0-or-later
 */
#ifndef KIS_COLORSPACE_GRAYSCALE_U16_H_
#define KIS_COLORSPACE_GRAYSCALE_U16_H_

#include "KoColorModelStandardIds.h"
#include "LcmsColorSpace.h"
#include <KLocalizedString>
#include <KoColorSpaceTraits.h>

typedef KoColorSpaceTrait<quint16, 2, 1> GrayAU16Traits;

class GrayAU16ColorSpace : public LcmsColorSpace<GrayAU16Traits>
{
public:
    GrayAU16ColorSpace(const QString &name, KoColorProfile *p);

    bool willDegrade(ColorSpaceIndependence) const override
    {
        return false;
    }

    KoID colorModelId() const override
    {
        return GrayAColorModelID;
    }

    KoID colorDepthId() const override
    {
        return Integer16BitsColorDepthID;
    }

    virtual KoColorSpace *clone() const;

    void colorToXML(const quint8 *pixel, QDomDocument &doc, QDomElement &colorElt) const override;

    void colorFromXML(quint8 *pixel, const QDomElement &elt) const override;

    void toHSY(const QVector<double> &channelValues, qreal *hue, qreal *sat, qreal *luma) const override;
    QVector<double> fromHSY(qreal *hue, qreal *sat, qreal *luma) const override;
    void toYUV(const QVector<double> &channelValues, qreal *y, qreal *u, qreal *v) const override;
    QVector<double> fromYUV(qreal *y, qreal *u, qreal *v) const override;

    static QString colorSpaceId()
    {
        return "GRAYAU16";
    }
};

class GrayAU16ColorSpaceFactory : public LcmsColorSpaceFactory
{
public:
    GrayAU16ColorSpaceFactory()
        : LcmsColorSpaceFactory(TYPE_GRAYA_16, cmsSigGrayData)
    {
    }

    QString id() const override
    {
        return GrayAU16ColorSpace::colorSpaceId();
    }

    QString name() const override
    {
        return i18n("Grayscale (16-bit integer/channel)");
    }

    KoID colorModelId() const override
    {
        return GrayAColorModelID;
    }

    KoID colorDepthId() const override
    {
        return Integer16BitsColorDepthID;
    }

    int referenceDepth() const override
    {
        return 16;
    }

    bool userVisible() const override
    {
        return true;
    }

    KoColorSpace *createColorSpace(const KoColorProfile *p) const override
    {
        return new GrayAU16ColorSpace(name(), p->clone());
    }

    QString defaultProfile() const override
    {
        return "gray built-in";
    }
};

#endif // KIS_STRATEGY_COLORSPACE_GRAYSCALE_H_
