/*
 * This program is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License, version 2.1 as published by the Free Software
 * Foundation.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, you can obtain a copy at http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html
 * or from the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * Copyright (c) 2006 - 2009 Pentaho Corporation and Contributors.  All rights reserved.
 */

package org.pentaho.reporting.libraries.formula.typing;

import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;

/**
 * Creation-Date: 10.04.2007, 14:13:40
 *
 * @author Thomas Morgner
 */
public class TypeConversionException extends EvaluationException
{
  private static final long serialVersionUID = -12507914833915502L;
  private static ThreadLocal localInstance = new ThreadLocal();

  protected TypeConversionException()
  {
    super(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
  }

  public static TypeConversionException getInstance()
  {
    final TypeConversionException o = (TypeConversionException) localInstance.get();
    if (o == null)
    {
      final TypeConversionException retval = new TypeConversionException();
      localInstance.set(retval);
      return retval;
    }

    o.fillInStackTrace();
    return o;
  }
}
