/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib.tuple;

import java.util.List;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.atlas.lib.tuple.Tuple0;
import org.apache.jena.atlas.lib.tuple.Tuple1;
import org.apache.jena.atlas.lib.tuple.Tuple2;
import org.apache.jena.atlas.lib.tuple.Tuple3;
import org.apache.jena.atlas.lib.tuple.Tuple4;
import org.apache.jena.atlas.lib.tuple.Tuple5;
import org.apache.jena.atlas.lib.tuple.Tuple6;
import org.apache.jena.atlas.lib.tuple.Tuple7;
import org.apache.jena.atlas.lib.tuple.Tuple8;
import org.apache.jena.atlas.lib.tuple.TupleN;

public class TupleFactory {
    private TupleFactory() {
    }

    @SafeVarargs
    public static <X> Tuple<X> tuple(X ... xs) {
        switch (xs.length) {
            case 0: {
                return TupleFactory.create0();
            }
            case 1: {
                return TupleFactory.create1(xs[0]);
            }
            case 2: {
                return TupleFactory.create2(xs[0], xs[1]);
            }
            case 3: {
                return TupleFactory.create3(xs[0], xs[1], xs[2]);
            }
            case 4: {
                return TupleFactory.create4(xs[0], xs[1], xs[2], xs[3]);
            }
            case 5: {
                return TupleFactory.create5(xs[0], xs[1], xs[2], xs[3], xs[4]);
            }
            case 6: {
                return TupleFactory.create6(xs[0], xs[1], xs[2], xs[3], xs[4], xs[5]);
            }
            case 7: {
                return TupleFactory.create7(xs[0], xs[1], xs[2], xs[3], xs[4], xs[5], xs[6]);
            }
            case 8: {
                return TupleFactory.create8(xs[0], xs[1], xs[2], xs[3], xs[4], xs[5], xs[6], xs[7]);
            }
        }
        return TupleFactory.asTuple(xs);
    }

    public static <X> Tuple<X> create(X[] xs) {
        switch (xs.length) {
            case 0: {
                return TupleFactory.create0();
            }
            case 1: {
                return TupleFactory.create1(xs[0]);
            }
            case 2: {
                return TupleFactory.create2(xs[0], xs[1]);
            }
            case 3: {
                return TupleFactory.create3(xs[0], xs[1], xs[2]);
            }
            case 4: {
                return TupleFactory.create4(xs[0], xs[1], xs[2], xs[3]);
            }
            case 5: {
                return TupleFactory.create5(xs[0], xs[1], xs[2], xs[3], xs[4]);
            }
            case 6: {
                return TupleFactory.create6(xs[0], xs[1], xs[2], xs[3], xs[4], xs[5]);
            }
            case 7: {
                return TupleFactory.create7(xs[0], xs[1], xs[2], xs[3], xs[4], xs[5], xs[6]);
            }
            case 8: {
                return TupleFactory.create8(xs[0], xs[1], xs[2], xs[3], xs[4], xs[5], xs[6], xs[7]);
            }
        }
        return TupleN.create(xs);
    }

    public static <X> Tuple<X> asTuple(X[] xs) {
        return TupleN.wrap(xs);
    }

    public static <X> Tuple<X> create(List<X> xs) {
        Object[] xa = new Object[xs.size()];
        return TupleFactory.tuple(xs.toArray(xa));
    }

    public static <X> Tuple0<X> create0() {
        return new Tuple0();
    }

    public static <X> Tuple1<X> create1(X x1) {
        return new Tuple1<X>(x1);
    }

    public static <X> Tuple2<X> create2(X x1, X x2) {
        return new Tuple2<X>(x1, x2);
    }

    public static <X> Tuple3<X> create3(X x1, X x2, X x3) {
        return new Tuple3<X>(x1, x2, x3);
    }

    public static <X> Tuple4<X> create4(X x1, X x2, X x3, X x4) {
        return new Tuple4<X>(x1, x2, x3, x4);
    }

    public static <X> Tuple5<X> create5(X x1, X x2, X x3, X x4, X x5) {
        return new Tuple5<X>(x1, x2, x3, x4, x5);
    }

    public static <X> Tuple6<X> create6(X x1, X x2, X x3, X x4, X x5, X x6) {
        return new Tuple6<X>(x1, x2, x3, x4, x5, x6);
    }

    public static <X> Tuple7<X> create7(X x1, X x2, X x3, X x4, X x5, X x6, X x7) {
        return new Tuple7<X>(x1, x2, x3, x4, x5, x6, x7);
    }

    public static <X> Tuple8<X> create8(X x1, X x2, X x3, X x4, X x5, X x6, X x7, X x8) {
        return new Tuple8<X>(x1, x2, x3, x4, x5, x6, x7, x8);
    }
}

